PSCAD 4.2.0

Settings
 {
 Id = "940000410.1144790484"
 Author = "gdi.jayas"
 Desc = "Simple case with chatter elimination"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.2
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144790464
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,16,[597,467],100)
   {
   -Sticky-([18,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,144,342,432
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Definition of Chatter:
---------------------------

A numerical oscillation (every time step) in v or i which is caused by trapezoidal integration.
It is not realistic.

Voltage chatter occurs whenever a disturbance is applied at a node to which only inductors are connected.

Current chatter occurs whenever a disturbance is applied at a location where capacitors are connected in a loop.

Chatter can be initiated by switching actions, or by steps in current injections (or voltage sources).

Chatter is not caused by interruption in the current in an inductor at a non-zero point.
"
    }
   -Sticky-([450,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 450,144,1134,504
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Chatter Elimination Techniques:
--------------------------------------------

1) Add damping resistors.  This method will cause the oscillation to damp out within a few cycles, but it will add extra damping to the solution.

2) CDA - Critical Damping Adjustment.  This method eliminates chatter by changing from Trapezoidal Integration to 2 time steps of rectangular integration.  This will solve the chatter problem, but
the solution accuracy is degraded (albeit only for a few time steps) due to the less accurate integration approximation.  Rectangular integration can also be numerically unstable (whereas trapezoidal
is always stable).

3) 1/2 Step Interpolation.  This method interpolates between 0 and 1 (to 0.5), then steps from 0.5 to 1.5 (using the regular trapezoidal method), and then interpolates back to 1.0 to complete the time step.

4) Root Matching.  This is a new integration technique which replaces the standard trapezoidal integration algorithm.  It does not initiate chatter, so a removal process is not required.
- Root matching can only be formulated where branches contain at least 2 or more elements (ie RL, LC..) so is ineffective for pure inductive node problems.    
- Branches solved with Root Matching can be intermixed in the same solution with branches solved with other integration techniques.
- Root Matching is always numerically stable.
- Root Matching is as efficient (or more efficient) numerically than trapezoidal integration.
"
    }
   -Sticky-([18,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,486,342,846
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
PSCAD/EMTDC:
----------------------

PSCAD/EMTDC uses Root Matching for T-Lines and Cables, and is partially implemented in the main RLC network solution.

EMTDC also uses 1/2 Step interpolation techniques whenever a switch occurs, or whenever chatter is detected.

The example below can run with interpolation on or off, and with chatter removal on or off for comparison.

When you run the case the first time, interpolation and chatter removal should both be on.  This is the correct solution.

To turn off interpolation, get \"Project Settings...\" of this case and select \"Simulation\" tab and deselect \"interpolate switching events to the precise time\". Re-run the case.  Since chatter removal is still on, the only difference will be that you will see a slight amount of -ve current in the breaker.


Next, turn off chatter removal, and the inductor voltage (VL) will chatter wildly when the breaker is open.  The oscillation in the voltage is incorrect due to trapezoidal integration."
    }
   0.source_1([90,990],1,0,-1)
    {
    Name = "Source1"
    Type = "6"
    Grnd = "1"
    Spec = "0"
    Cntrl = "0"
    AC = "1"
    Vm = "132.79 [kV]"
    Tc = "0.05 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   0.inductor([324,954],1,0,-1)
    {
    L = "0.1 [H]"
    }
   -Wire-([324,918],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.ground([324,1026],1,0,-1)
    {
    }
   -Wire-([90,918],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([54,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([108,1116],0,28495816,40)
    {
    Name = "V1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200"
    Max = "200"
    }
   0.datalabel([54,1116],0,0,-1)
    {
    Name = "V1"
    }
   0.ammeter([324,990],1,0,30)
    {
    Name = "IL"
    }
   -Wire-([270,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([324,1152],0,36021640,60)
    {
    Name = "IL"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-10"
    Max = "6"
    }
   0.datalabel([270,1152],0,0,-1)
    {
    Name = "IL"
    }
   -Wire-([90,918],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([270,1116],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([324,1116],0,28429928,50)
    {
    Name = "VL"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200"
    Max = "200"
    }
   0.datalabel([270,1116],0,0,-1)
    {
    Name = "VL"
    }
   -Wire-([108,1350],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.tbreakn([72,1350],4,0,90)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "TOpen"
    TO2 = "TClose"
    }
   0.datalabel([162,1350],0,0,-1)
    {
    Name = "BrkSgn"
    }
   -Wire-([54,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([108,1152],0,28545064,120)
    {
    Name = "IBrk"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([54,1152],0,0,-1)
    {
    Name = "IBrk"
    }
   -Wire-([288,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([324,1278],0,0,-1)
    {
    Name = "TOpen"
    }
   0.var([252,1278],0,27826832,70)
    {
    Name = "TOpen"
    Group = ""
    Display = "0"
    Max = ".2"
    Min = "0.0"
    Value = "0.1"
    Units = "sec"
    Collect = "1"
    }
   -Wire-([288,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([324,1314],0,0,-1)
    {
    Name = "TClose"
    }
   0.var([252,1314],0,27189488,80)
    {
    Name = "TClose"
    Group = ""
    Display = "0"
    Max = ".2"
    Min = "0.0"
    Value = "0.14"
    Units = "sec"
    Collect = "1"
    }
   -ControlPanel-([234,1350],0)
    {
    Name = "$(GROUP) : Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(27826832)
    Slider(27189488)
    }
   -Wire-([54,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([108,1188],0,27918376,110)
    {
    Name = "BrkSgn"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "1.5"
    }
   0.datalabel([54,1188],0,0,-1)
    {
    Name = "BrkSgn"
    }
   -Wire-([252,918],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.breaker1([216,918],4,0,100)
    {
    NAME = "BrkSgn"
    OPCUR = "0"
    ENAB = "0"
    ViewB = "0"
    CLVL = "0.0 [kA]"
    ROFF = "1.E12 [ohm]"
    RON = "0.0005 [ohm]"
    PRER = "0.1 [ohm]"
    TD = "0.0 [s]"
    TDR = "0.05 [s]"
    PostIns = "0"
    TDBO = "0.005 [s]"
    IBR = "IBrk"
    SBR = ""
    BOpen = "0"
    }
   -Sticky-([360,36],0)
    {
    Name = ""
    Font = 2
    Bounds = 360,36,792,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "CHATTER ELIMINATION"
    }
   -Plot-([450,540],0)
    {
    Title = "Inductor V and I, V1 and Brk signal"
    Draw = 1
    Area = [0,0,684,1008]
    Posn = [450,540]
    Icon = [450,540]
    Extents = 0,0,684,1008
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,684,250],"Voltage")
     {
     Options = 0
     Units = ""
     Curve(28429928,"VL",0,,,)
     }
    Graph([0,250],[0,0,684,250],"Current")
     {
     Options = 0
     Units = ""
     Curve(36021640,"IL",0,,,)
     }
    Graph([0,500],[0,0,684,250],"Voltage")
     {
     Options = 0
     Units = ""
     Curve(28495816,"V1",0,,,)
     }
    PGraph([0,750],[0,0,684,195],"PolyGraph")
     {
     Options = 0
     Curve(27918376,"BrkSgn",0,,,1)
     }
    }
   0.voltmetergnd([126,918],0,0,10)
    {
    Name = "V1"
    }
   0.voltmetergnd([288,918],0,0,20)
    {
    Name = "VL"
    }
   }
  }
 }

